/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.network.capability;

import com.alcatrazescapee.alcatrazcore.network.PacketTContainerUpdate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;

@ParametersAreNonnullByDefault
public abstract class CapabilityContainerListener<T>
implements IContainerListener {
    private final EntityPlayerMP player;
    private final Capability<T> capability;
    private final EnumFacing targetFace;

    public CapabilityContainerListener(EntityPlayerMP player, Capability<T> capability, @Nullable EnumFacing targetFace) {
        this.player = player;
        this.capability = capability;
        this.targetFace = targetFace;
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> items) {
        NonNullList syncableItemsList = NonNullList.func_191197_a((int)items.size(), (Object)ItemStack.field_190927_a);
        for (int index = 0; index < syncableItemsList.size(); ++index) {
            ItemStack stack = (ItemStack)syncableItemsList.get(index);
            if (this.shouldSyncItem(stack)) {
                syncableItemsList.set(index, (Object)stack);
                continue;
            }
            syncableItemsList.set(index, (Object)ItemStack.field_190927_a);
        }
        PacketTContainerUpdate<T, ?> message = this.createBulkUpdateMessage(container.field_75152_c, (NonNullList<ItemStack>)syncableItemsList);
        if (message.hasData()) {
            this.sendToPlayer(this.player, message);
        }
    }

    public void func_71111_a(Container container, int slotIndex, ItemStack stack) {
        if (!this.shouldSyncItem(stack)) {
            return;
        }
        Object cap = stack.getCapability(this.capability, this.targetFace);
        if (cap == null) {
            return;
        }
        PacketTContainerUpdate<Object, ?> message = this.createSingleUpdateMessage(container.field_75152_c, slotIndex, cap);
        if (message.hasData()) {
            this.sendToPlayer(this.player, message);
        }
    }

    public void func_71112_a(Container container, int ID, int value) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }

    protected abstract PacketTContainerUpdate<T, ?> createBulkUpdateMessage(int var1, NonNullList<ItemStack> var2);

    protected abstract PacketTContainerUpdate<T, ?> createSingleUpdateMessage(int var1, int var2, T var3);

    protected abstract void sendToPlayer(EntityPlayerMP var1, PacketTContainerUpdate<T, ?> var2);

    protected boolean shouldSyncItem(ItemStack stack) {
        return stack.hasCapability(this.capability, this.targetFace);
    }
}

